/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.signature;

import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.signature.RBlastMoleculeSignature;
import uk.ac.ebi.reactionblast.tools.labelling.AtomContainerAtomPermutor;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class RBlastAtomSignatureLabellingAdaptor
implements ICanonicalMoleculeLabeller {
    private static final Logger LOG = Logger.getLogger(RBlastAtomSignatureLabellingAdaptor.class.getName());
    private int atomIndex;
    private int height;

    public RBlastAtomSignatureLabellingAdaptor(int atomIndex) {
        this.atomIndex = atomIndex;
        this.height = -1;
    }

    public RBlastAtomSignatureLabellingAdaptor(int atomIndex, int height) {
        this.atomIndex = atomIndex;
        this.height = height;
    }

    @Override
    public IAtomContainer getCanonicalMolecule(IAtomContainer container) {
        return AtomContainerAtomPermutor.permute(this.getCanonicalPermutation(container), container);
    }

    @Override
    public int[] getCanonicalPermutation(IAtomContainer container) {
        RBlastMoleculeSignature molSig = new RBlastMoleculeSignature(container);
        if (this.height == -1) {
            return molSig.getAtomSignature(this.atomIndex).getCanonicalLabelling(container.getAtomCount());
        }
        return molSig.getAtomSignature(this.atomIndex, this.height).getCanonicalLabelling(container.getAtomCount());
    }
}

