/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.compare;

import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeStereoAnalysisResult;

public class WedgeStereoComparisonResult {
    private static final Logger LOG = Logger.getLogger(WedgeStereoComparisonResult.class.getName());
    private final IAtom firstAtom;
    private final IAtomContainer firstAtomContainer;
    private final WedgeStereoAnalysisResult resultForFirst;
    private final IAtom secondAtom;
    private final IAtomContainer secondAtomContainer;
    private final WedgeStereoAnalysisResult resultForSecond;

    public WedgeStereoComparisonResult(IAtom firstAtom, IAtomContainer firstAtomContainer, WedgeStereoAnalysisResult resultForFirst, IAtom secondAtom, IAtomContainer secondAtomContainer, WedgeStereoAnalysisResult resultForSecond) {
        this.firstAtom = firstAtom;
        this.firstAtomContainer = firstAtomContainer;
        this.resultForFirst = resultForFirst;
        this.secondAtom = secondAtom;
        this.secondAtomContainer = secondAtomContainer;
        this.resultForSecond = resultForSecond;
    }

    public int getIndexOfFirst() {
        return this.firstAtomContainer.getAtomNumber(this.firstAtom);
    }

    public WedgeStereoAnalysisResult getResultForFirst() {
        return this.resultForFirst;
    }

    public int getIndexOfSecond() {
        return this.secondAtomContainer.getAtomNumber(this.secondAtom);
    }

    public WedgeStereoAnalysisResult getResultForSecond() {
        return this.resultForSecond;
    }

    public IAtom getFirst() {
        return this.firstAtom;
    }

    public IAtomContainer getFirstContainer() {
        return this.firstAtomContainer;
    }

    public IAtom getSecond() {
        return this.secondAtom;
    }

    public IAtomContainer getSecondContainer() {
        return this.secondAtomContainer;
    }

    public String toString() {
        String firstID = this.firstAtom.getID() == null ? String.valueOf(this.firstAtomContainer.getAtomNumber(this.firstAtom)) : this.firstAtom.getID();
        String secondID = this.secondAtom.getID() == null ? String.valueOf(this.secondAtomContainer.getAtomNumber(this.secondAtom)) : this.secondAtom.getID();
        return firstID + "\t:\t" + (Object)((Object)this.resultForFirst) + "\t\t" + secondID + "\t:\t" + (Object)((Object)this.resultForSecond);
    }
}

