/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.wedge;

import java.util.SortedMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;

public abstract class WedgeRule {
    private int matchPoint;

    public int[] getMatchPermutation() {
        int length = this.getPattern().length;
        int[] permutation = new int[length];
        if (this.matchPoint != -1) {
            int pi = this.matchPoint;
            for (int i = 0; i < length; ++i) {
                permutation[i] = pi++;
                if (pi < length) continue;
                pi = 0;
            }
        }
        return permutation;
    }

    public boolean matches(IBond.Stereo[] stereoList) {
        IBond.Stereo[] pattern = this.getPattern();
        if (stereoList.length != pattern.length) {
            return false;
        }
        int length = pattern.length;
        int patternIndex = 0;
        int matchIndex = 0;
        this.matchPoint = -1;
        while (patternIndex < length && matchIndex < 2 * length) {
            IBond.Stereo patternStereo = pattern[patternIndex];
            IBond.Stereo matchStereo = matchIndex < length ? stereoList[matchIndex] : stereoList[matchIndex - length];
            if (patternStereo == matchStereo) {
                ++patternIndex;
                ++matchIndex;
                continue;
            }
            if (patternIndex == 0) {
                ++matchIndex;
                continue;
            }
            patternIndex = 0;
        }
        if (patternIndex < pattern.length) {
            return false;
        }
        this.matchPoint = matchIndex - length;
        return true;
    }

    public abstract IBond.Stereo[] getPattern();

    public abstract IStereoElement execute(IAtom var1, IAtomContainer var2, SortedMap<Double, IBond> var3);
}

