/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class ExtAtomContainerManipulator
extends AtomContainerManipulator
implements Serializable {
    static final Logger logger = Logger.getLogger(ExtAtomContainerManipulator.class.getName());
    static final long serialVersionUID = 1786786539472837495L;

    public static IAtomContainer removeHydrogensExceptSingleAndPreserveAtomID(IAtomContainer org) {
        return ExtAtomContainerManipulator.copyAndSuppressedHydrogens(org);
    }

    public static IAtomContainer copyAndSuppressedHydrogens(IAtomContainer org) {
        try {
            IAtomContainer clone = org.clone();
            clone.setID(org.getID());
            for (int i = 0; i < org.getAtomCount(); ++i) {
                int implicitHydrogenCount = ExtAtomContainerManipulator.getImplicitHydrogenCount(clone.getAtom(i));
                clone.getAtom(i).setImplicitHydrogenCount(implicitHydrogenCount);
                clone.getAtom(i).setProperties(org.getAtom(i).getProperties());
                clone.getAtom(i).setFlags(org.getAtom(i).getFlags());
            }
            return ExtAtomContainerManipulator.suppressHydrogens(clone);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("atom container could not be cloned");
        }
    }

    private static void printAtoms(IAtomContainer mol) {
        System.out.print("Atom: ");
        for (IAtom a : mol.atoms()) {
            System.out.print(a.getSymbol());
            System.out.print("[" + a.getFormalCharge() + "]");
            if (a.getID() == null) continue;
            System.out.print("[" + a.getID() + "]");
        }
        System.out.println();
        System.out.println();
    }

    public static synchronized IAtomContainer checkAndCleanMolecule(IAtomContainer molecule_orignal) {
        boolean isMarkush = false;
        IAtomContainer molecule = molecule_orignal;
        for (IAtom atom : molecule.atoms()) {
            if (!atom.getSymbol().equals("R")) continue;
            isMarkush = true;
            break;
        }
        if (isMarkush) {
            logger.log(Level.WARNING, "Skipping Markush structure for sanity check");
        }
        if (!ConnectivityChecker.isConnected(molecule)) {
            IAtomContainerSet fragments = ConnectivityChecker.partitionIntoMolecules(molecule);
            if (fragments.getAtomContainerCount() > 2) {
                logger.log(Level.WARNING, "More than 2 components. Skipped");
            } else {
                IAtomContainer frag1 = fragments.getAtomContainer(0);
                IAtomContainer frag2 = fragments.getAtomContainer(1);
                molecule = frag1.getAtomCount() > frag2.getAtomCount() ? frag1 : frag2;
            }
        }
        ExtAtomContainerManipulator.aromatizeMolecule(molecule);
        return molecule;
    }

    public static void aromatizeMolecule(IAtomContainer mol) {
        try {
            IRingSet ringSet = null;
            try {
                AllRingsFinder arf = new AllRingsFinder();
                ringSet = arf.findAllRings(mol);
                RingSetManipulator.markAromaticRings(ringSet);
            }
            catch (CDKException e) {
                logger.log(Level.WARNING, "Error in find and assigning rings in the molecule. ", mol.getID());
            }
            try {
                try {
                    ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
                    ExtAtomContainerManipulator.aromatizeCDK(mol);
                }
                catch (CDKException e) {
                    ExtAtomContainerManipulator.aromatizeDayLight(mol);
                }
            }
            catch (CDKException e) {
                logger.log(Level.WARNING, "Error in aromaticity dectection. ", mol.getID());
            }
            if (ringSet == null) {
                return;
            }
            for (int i = 0; i <= mol.getAtomCount() - 1; ++i) {
                mol.getAtom(i).setFlag(32, false);
                for (int j = 0; j <= ringSet.getAtomContainerCount() - 1; ++j) {
                    boolean haveatom;
                    IRing ring = (IRing)ringSet.getAtomContainer(j);
                    if (!ring.getFlag(32) || !(haveatom = ring.contains(mol.getAtom(i))) || ring.getAtomCount() != 6) continue;
                    mol.getAtom(i).setFlag(32, true);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Aromaticity detection failed for molecule. ", mol.getID());
        }
    }

    public static IAtomContainer cloneWithIDs(IAtomContainer container) throws CloneNotSupportedException {
        int i;
        IAtomContainer ac = new AtomContainer(container).clone();
        for (i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setID(container.getAtom(i).getID());
            if (ac.getAtom(i).getProperties() != null) continue;
            ac.getAtom(i).setProperties(new HashMap<Object, Object>());
        }
        for (i = 0; i < ac.getBondCount(); ++i) {
            if (ac.getBond(i).getProperties() != null) continue;
            ac.getBond(i).setProperties(new HashMap<Object, Object>());
        }
        ac.setProperties(container.getProperties());
        ac.setFlags(container.getFlags());
        ac.setID(container.getID());
        ac.notifyChanged();
        return ac;
    }

    public static IAtomContainer newInstanceWithIDs(IAtomContainer container) throws CloneNotSupportedException {
        int i;
        IAtomContainer ac = container.getBuilder().newInstance(IAtomContainer.class, container);
        for (i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setID(container.getAtom(i).getID());
            if (ac.getAtom(i).getProperties() != null) continue;
            ac.getAtom(i).setProperties(new HashMap<Object, Object>());
        }
        for (i = 0; i < ac.getBondCount(); ++i) {
            if (ac.getBond(i).getProperties() != null) continue;
            ac.getBond(i).setProperties(new HashMap<Object, Object>());
        }
        ac.setProperties(container.getProperties());
        ac.setFlags(container.getFlags());
        ac.setID(container.getID());
        ac.notifyChanged();
        return ac;
    }

    public static int getExplicitHydrogenCount(IAtomContainer atomContainer, IAtom atom) {
        int hCount = 0;
        for (IAtom connectedAtom : atomContainer.getConnectedAtomsList(atom)) {
            if (!connectedAtom.getSymbol().equals("H")) continue;
            ++hCount;
        }
        return hCount;
    }

    public static int getImplicitHydrogenCount(IAtom atom) {
        return Objects.equals(atom.getImplicitHydrogenCount(), CDKConstants.UNSET) ? 0 : atom.getImplicitHydrogenCount();
    }

    public static int getHydrogenCount(IAtomContainer atomContainer, IAtom atom) {
        return ExtAtomContainerManipulator.getExplicitHydrogenCount(atomContainer, atom) + ExtAtomContainerManipulator.getImplicitHydrogenCount(atom);
    }

    public static IAtomContainer convertExplicitToImplicitHydrogens(IAtomContainer atomContainer) {
        IAtomContainer mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, atomContainer);
        if (mol.getAtomCount() > 1) {
            mol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
        } else if (mol.getAtomCount() == 1 && !atomContainer.atoms().iterator().next().getSymbol().equalsIgnoreCase("H")) {
            ExtAtomContainerManipulator.convertImplicitToExplicitHydrogens(mol);
            mol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
        } else if (mol.getAtomCount() == 1 && atomContainer.atoms().iterator().next().getSymbol().equalsIgnoreCase("H")) {
            System.err.println("WARNING: single hydrogen atom removal not supported!");
        }
        mol.setProperties(atomContainer.getProperties());
        mol.setFlags(atomContainer.getFlags());
        if (atomContainer.getID() != null) {
            mol.setID(atomContainer.getID());
        }
        return mol;
    }

    public static void percieveAtomTypesAndConfigureAtoms(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            if (atom instanceof IPseudoAtom) continue;
            try {
                IAtomType matched = matcher.findMatchingAtomType(container, atom);
                if (matched == null) continue;
                AtomTypeManipulator.configure(atom, matched);
            }
            catch (CDKException e) {
                logger.log(Level.WARNING, "Failed to find Matching AtomType! {0}{1}", new Object[]{atom.getSymbol(), e});
            }
        }
    }

    public static IAtomContainer addExplicitH(IAtomContainer gMol) throws CloneNotSupportedException {
        IAtomContainer mol = ExtAtomContainerManipulator.cloneWithIDs(gMol);
        CDKHydrogenAdder hydAdder = CDKHydrogenAdder.getInstance(mol.getBuilder());
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
            for (IAtom a : mol.atoms()) {
                if (!(a instanceof IPseudoAtom)) {
                    try {
                        hydAdder.addImplicitHydrogens(mol, a);
                    }
                    catch (Exception e) {
                        a.setImplicitHydrogenCount(0);
                        System.err.println("WARNING: Error in adding Hydrogen:" + a.getSymbol());
                        logger.log(Level.WARNING, "This might effect the final calculations!");
                    }
                    continue;
                }
                a.setImplicitHydrogenCount(0);
            }
        }
        catch (CDKException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        ExtAtomContainerManipulator.convertImplicitToExplicitHydrogens(mol);
        return mol;
    }

    public static void aromatizeDayLight(IAtomContainer molecule) throws CDKException {
        ElectronDonation model = ElectronDonation.daylight();
        CycleFinder cycles = Cycles.or(Cycles.all(), Cycles.relevant());
        Aromaticity aromaticity = new Aromaticity(model, cycles);
        try {
            aromaticity.apply(molecule);
        }
        catch (CDKException e) {
            logger.log(Level.WARNING, "Aromaticity detection failed due to presence of unset atom hybridisation", molecule.getID());
        }
    }

    public static void aromatizeCDK(IAtomContainer molecule) throws CDKException {
        ElectronDonation model = ElectronDonation.cdk();
        CycleFinder cycles = Cycles.cdkAromaticSet();
        Aromaticity aromaticity = new Aromaticity(model, cycles);
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
        try {
            aromaticity.apply(molecule);
        }
        catch (CDKException e) {
            logger.log(Level.WARNING, "Aromaticity detection failed due to presence of unset atom hybridisation", molecule.getID());
        }
    }

    public static void fixDativeBonds(IAtomContainer mol) {
        if (!(mol instanceof IQueryAtomContainer)) {
            for (IBond bond : mol.bonds()) {
                if (bond.getOrder() != IBond.Order.UNSET) continue;
                bond.setOrder(IBond.Order.SINGLE);
            }
        }
    }

    static void setNullHCountToZero(IAtomContainer mol) {
        for (IAtom a : mol.atoms()) {
            if (a.getImplicitHydrogenCount() != null) continue;
            a.setImplicitHydrogenCount(0);
        }
    }
}

