/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.util.logging.Logger;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;

public class LayoutCheck {
    private static final Logger LOG = Logger.getLogger(LayoutCheck.class.getName());

    public static IAtomContainer getMoleculeWithLayoutCheck(IAtomContainer mol) {
        if (!GeometryTools.has2DCoordinates(mol)) {
            try {
                StructureDiagramGenerator sdg = new StructureDiagramGenerator(new AtomContainer(mol));
                sdg.generateCoordinates();
                mol = sdg.getMolecule();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mol;
    }

    public static IChemModel getChemModelWithMoleculeWithLayoutCheck(IAtomContainer mol) {
        ChemModel chemModel = new ChemModel();
        chemModel.setMoleculeSet(ConnectivityChecker.partitionIntoMolecules(mol));
        for (IAtomContainer molecule : MoleculeSetManipulator.getAllAtomContainers(chemModel.getMoleculeSet())) {
            if (!GeometryTools.has2DCoordinates(molecule)) continue;
            try {
                StructureDiagramGenerator sdg = new StructureDiagramGenerator(new AtomContainer(molecule));
                sdg.generateCoordinates();
                molecule = sdg.getMolecule();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return chemModel;
    }

    private LayoutCheck() {
    }
}

