/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.tools.utility.EBIDoubleUtility;

public class ReactionSimilarityTool {
    private static final Logger LOG = Logger.getLogger(ReactionSimilarityTool.class.getName());

    public static double getSimilarityScore(double alpha, double beta, double bondSimilarity, double structuralSimilarity) throws CDKException {
        double score = 0.0;
        double BC = bondSimilarity;
        double SC = structuralSimilarity;
        if (alpha == 0.0 && beta == 0.0) {
            throw new CDKException("Both alpha & beta can't be zero at the same time");
        }
        if (BC == 0.0 && SC == 0.0) {
            score = 0.0;
        } else {
            double structureScore = beta / (alpha + beta) * SC;
            double bondScore = alpha / (alpha + beta) * BC;
            score = bondScore + structureScore;
        }
        DecimalFormat df = new DecimalFormat("0.00");
        df.setMaximumFractionDigits(2);
        String a = df.format(score);
        score = Double.parseDouble(a);
        return score;
    }

    public static double getSimilarityScore(double alpha, double beta, double gamma, double bondSimilarity, double structuralSimilarity, double stereoSimilarity) throws CDKException {
        double score = 0.0;
        double BC = bondSimilarity;
        double SC = structuralSimilarity;
        double ST = stereoSimilarity;
        if (alpha == 0.0 && beta == 0.0 && gamma == 0.0) {
            throw new CDKException("Both alpha & beta can't be zero at the same time");
        }
        if (BC == 0.0 && SC == 0.0) {
            score = 0.0;
        } else {
            double structureScore = beta / (alpha + beta + gamma) * SC;
            double bondScore = alpha / (alpha + beta + gamma) * BC;
            double stereoScore = gamma / (alpha + beta + gamma) * ST;
            score = bondScore + structureScore + stereoScore;
        }
        DecimalFormat df = new DecimalFormat("0.00");
        df.setMaximumFractionDigits(2);
        String a = df.format(score);
        score = Double.parseDouble(a);
        return score;
    }

    public static double getReactionSimilarity(double alpha, double beta, IPatternFingerprinter StructFP1, double[] bondFeatures1, IPatternFingerprinter StructFP2, double[] bondFeatures2, boolean oxidationPenalty) throws Exception {
        int size2;
        double score = 0.0;
        int size1 = StructFP1.getFingerprintSize();
        if (size1 != (size2 = StructFP2.getFingerprintSize())) {
            throw new CDKException("Features vectors must be of the same length");
        }
        if (alpha < 0.0 && beta < 0.0) {
            throw new CDKException("both alpha and beta can't =< be zero");
        }
        double similarityOfBondChanges = ReactionSimilarityTool.getSimilarity(bondFeatures1, bondFeatures2);
        double[] structFeatures1 = StructFP1.getWeightedHashedFingerPrint();
        double[] structFeatures2 = StructFP2.getWeightedHashedFingerPrint();
        double similarityStruct = ReactionSimilarityTool.getSimilarity(structFeatures1, structFeatures2);
        score = ReactionSimilarityTool.getSimilarityScore(alpha, beta, similarityOfBondChanges, similarityStruct);
        return score;
    }

    public static double getReactionSimilarity(double alpha, double beta, IPatternFingerprinter StructFP1, IPatternFingerprinter BondsCF1, IPatternFingerprinter BondsOC1, IPatternFingerprinter BondsST1, IPatternFingerprinter StructFP2, IPatternFingerprinter BondsCF2, IPatternFingerprinter BondsOC2, IPatternFingerprinter BondsST2) throws Exception {
        double score = 0.0;
        if (alpha < 0.0 && beta < 0.0) {
            throw new CDKException("both alpha and beta can't =< be zero");
        }
        double[] bondFeatures1 = EBIDoubleUtility.append(BondsCF1.getWeightedHashedFingerPrint(), BondsOC1.getWeightedHashedFingerPrint(), BondsST1.getWeightedHashedFingerPrint());
        double[] bondFeatures2 = EBIDoubleUtility.append(BondsCF2.getWeightedHashedFingerPrint(), BondsOC2.getWeightedHashedFingerPrint(), BondsST2.getWeightedHashedFingerPrint());
        double similarityOfBondChanges = ReactionSimilarityTool.getSimilarity(bondFeatures1, bondFeatures2);
        double[] structFeatures1 = StructFP1.getWeightedHashedFingerPrint();
        double[] structFeatures2 = StructFP2.getWeightedHashedFingerPrint();
        double similarityStruct = ReactionSimilarityTool.getSimilarity(structFeatures1, structFeatures2);
        score = ReactionSimilarityTool.getSimilarityScore(alpha, beta, similarityOfBondChanges, similarityStruct);
        return score;
    }

    public static double getReactionSimilarity(double alpha, double beta, double gamma, IPatternFingerprinter StructFP1, IPatternFingerprinter BondsCF1, IPatternFingerprinter BondsOC1, IPatternFingerprinter BondsST1, IPatternFingerprinter StructFP2, IPatternFingerprinter BondsCF2, IPatternFingerprinter BondsOC2, IPatternFingerprinter BondsST2) throws Exception {
        double score = 0.0;
        if (alpha < 0.0 && beta < 0.0) {
            throw new CDKException("both alpha and beta can't =< be zero");
        }
        double[] bondFeatures1 = EBIDoubleUtility.append(BondsCF1.getWeightedHashedFingerPrint(), BondsOC1.getWeightedHashedFingerPrint());
        double[] bondFeatures2 = EBIDoubleUtility.append(BondsCF2.getWeightedHashedFingerPrint(), BondsOC2.getWeightedHashedFingerPrint());
        double similarityOfBondChanges = ReactionSimilarityTool.getSimilarity(bondFeatures1, bondFeatures2);
        double similarityOfStereoChanges = ReactionSimilarityTool.getSimilarity(BondsST1.getWeightedHashedFingerPrint(), BondsST2.getWeightedHashedFingerPrint());
        double[] structFeatures1 = StructFP1.getWeightedHashedFingerPrint();
        double[] structFeatures2 = StructFP2.getWeightedHashedFingerPrint();
        double similarityStruct = ReactionSimilarityTool.getSimilarity(structFeatures1, structFeatures2);
        score = ReactionSimilarityTool.getSimilarityScore(alpha, beta, gamma, similarityOfBondChanges, similarityStruct, similarityOfStereoChanges);
        return score;
    }

    public static double getPointWiseMutualInformation(double alpha, double beta, IPatternFingerprinter StructFP1, IPatternFingerprinter BondsCF1, IPatternFingerprinter BondsOC1, IPatternFingerprinter BondsST1, IPatternFingerprinter StructFP2, IPatternFingerprinter BondsCF2, IPatternFingerprinter BondsOC2, IPatternFingerprinter BondsST2) throws CDKException, Exception {
        int size2;
        double score = 0.0;
        int size1 = StructFP1.getFingerprintSize();
        if (size1 != (size2 = StructFP2.getFingerprintSize())) {
            throw new CDKException("Features vectors must be of the same length");
        }
        if (alpha < 0.0 && beta < 0.0) {
            throw new CDKException("both alpha and beta can't =< be zero");
        }
        double[] bondFeatures1 = EBIDoubleUtility.append(BondsCF1.getWeightedHashedFingerPrint(), BondsOC1.getWeightedHashedFingerPrint(), BondsST1.getWeightedHashedFingerPrint());
        double[] bondFeatures2 = EBIDoubleUtility.append(BondsCF2.getWeightedHashedFingerPrint(), BondsOC2.getWeightedHashedFingerPrint(), BondsST2.getWeightedHashedFingerPrint());
        double similarityOfBondChanges = ReactionSimilarityTool.getPointWiseMutualInformation(bondFeatures1, bondFeatures2);
        double[] structFeatures1 = StructFP1.getWeightedHashedFingerPrint();
        double[] structFeatures2 = StructFP2.getWeightedHashedFingerPrint();
        double similarityStruct = ReactionSimilarityTool.getPointWiseMutualInformation(structFeatures1, structFeatures2);
        score = ReactionSimilarityTool.getSimilarityScore(alpha, beta, similarityOfBondChanges, similarityStruct);
        return score;
    }

    public static boolean isSubset(double alpha, double beta, double[] StructFP1, double[] BondsCF1, double[] BondsOC1, double[] BondsST1, double[] StructFP2, double[] BondsCF2, double[] BondsOC2, double[] BondsST2) throws CDKException, Exception {
        boolean score = false;
        int size1 = StructFP1.length;
        int size2 = StructFP2.length;
        if (size1 != size2) {
            throw new CDKException("Features vectors must be of the same length");
        }
        if (alpha < 0.0 && beta < 0.0) {
            throw new CDKException("both alpha and beta can't =< be zero");
        }
        boolean similarityOfBondChanges = true;
        boolean similarityStruct = true;
        if (alpha > 0.0) {
            similarityOfBondChanges = ReactionSimilarityTool.isSubset(BondsCF1, BondsOC1, BondsST1, BondsCF2, BondsOC2, BondsST2);
        }
        if (beta > 0.0) {
            double[] structFeatures1 = StructFP1;
            double[] structFeatures2 = StructFP2;
            similarityStruct = ReactionSimilarityTool.isSubset(structFeatures1, structFeatures2);
        }
        if (similarityOfBondChanges && similarityStruct) {
            score = true;
        }
        return score;
    }

    public static boolean isSubset(double[] BondsCF1, double[] BondsOC1, double[] BondsST1, double[] BondsCF2, double[] BondsOC2, double[] BondsST2) throws CDKException, Exception {
        double[] bondFeatures1 = EBIDoubleUtility.append(BondsCF1, BondsOC1, BondsST1);
        double[] bondFeatures2 = EBIDoubleUtility.append(BondsCF2, BondsOC2, BondsST2);
        return ReactionSimilarityTool.isSubset(bondFeatures1, bondFeatures2);
    }

    public static boolean isSubset(double[] query2, double[] target) throws CDKException {
        if (query2.length != target.length) {
            throw new CDKException("Unequal Fingerprint size can't be processed");
        }
        for (int i = 0; i < query2.length; ++i) {
            if (!(query2[i] > target[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubset(IPatternFingerprinter query2, IPatternFingerprinter target) throws CDKException {
        if (query2.getFingerprintSize() != target.getFingerprintSize()) {
            throw new CDKException("Unequal Fingerprint size can't be processed");
        }
        BitSet q = query2.getHashedFingerPrint();
        BitSet t = target.getHashedFingerPrint();
        for (int i = 0; i < q.length(); ++i) {
            if (t.get(i) & q.get(i)) continue;
            return false;
        }
        return true;
    }

    public static double getSimilarity(IPatternFingerprinter fp1, IPatternFingerprinter fp2) throws CDKException, Exception {
        int size2;
        double score = 0.0;
        int size1 = fp1.getFingerprintSize();
        if (size1 != (size2 = fp2.getFingerprintSize())) {
            throw new CDKException("Features vectors must be of the same length");
        }
        double[] structFeatures1 = fp1.getWeightedHashedFingerPrint();
        double[] structFeatures2 = fp2.getWeightedHashedFingerPrint();
        score = ReactionSimilarityTool.getSimilarity(structFeatures1, structFeatures2);
        return score;
    }

    private static double getSimilarity(double[] bondFeatures1, double[] bondFeatures2) throws CDKException {
        double similarity = 0.0;
        if (bondFeatures1.length != bondFeatures2.length) {
            throw new CDKException("Features vectors must be of the same length");
        }
        int n = bondFeatures1.length;
        double ab = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ab += bondFeatures1[i] * bondFeatures2[i];
            a2 += bondFeatures1[i] * bondFeatures1[i];
            b2 += bondFeatures2[i] * bondFeatures2[i];
        }
        if (a2 > 0.0 && b2 > 0.0) {
            similarity = ab / (a2 + b2 - ab);
        }
        return similarity;
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    private static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    private static double logX(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    private static double getPointWiseMutualInformation(double[] bondFeatures1, double[] bondFeatures2) {
        int i;
        BitSet q = new BitSet(bondFeatures1.length);
        BitSet t = new BitSet(bondFeatures2.length);
        for (int i2 = 0; i2 < bondFeatures2.length; ++i2) {
            if (bondFeatures1[i2] > 0.0) {
                q.set(i2, true);
            } else {
                q.set(i2, false);
            }
            if (bondFeatures2[i2] > 0.0) {
                t.set(i2, true);
                continue;
            }
            t.set(i2, false);
        }
        ArrayList<Double> Pxy = new ArrayList<Double>(4);
        for (i = 0; i < 4; ++i) {
            Pxy.add(i, 0.0);
        }
        for (i = 0; i < q.size(); ++i) {
            if (q.get(i) && t.get(i)) {
                Pxy.add(3, (Double)Pxy.get(3) + 1.0);
            }
            if (q.get(i) && !t.get(i)) {
                Pxy.add(2, (Double)Pxy.get(2) + 1.0);
            }
            if (!q.get(i) && t.get(i)) {
                Pxy.add(1, (Double)Pxy.get(1) + 1.0);
            }
            if (q.get(i) || t.get(i)) continue;
            Pxy.add(0, (Double)Pxy.get(0) + 1.0);
        }
        for (i = 0; i < 4; ++i) {
            Pxy.set(i, (Double)Pxy.get(i) / (double)q.size());
        }
        double Px0 = (Double)Pxy.get(0) + (Double)Pxy.get(1);
        double Px1 = (Double)Pxy.get(2) + (Double)Pxy.get(3);
        double Py0 = (Double)Pxy.get(0) + (Double)Pxy.get(2);
        double Py1 = (Double)Pxy.get(1) + (Double)Pxy.get(3);
        double SI_0_0 = ReactionSimilarityTool.log2((Double)Pxy.get(0) / (Px0 * Py0));
        double SI_0_1 = ReactionSimilarityTool.log2((Double)Pxy.get(1) / (Px0 * Py1));
        double SI_1_0 = ReactionSimilarityTool.log2((Double)Pxy.get(2) / (Px1 * Py0));
        double SI_1_1 = ReactionSimilarityTool.log2((Double)Pxy.get(3) / (Px1 * Py1));
        double MI = (Double)Pxy.get(0) * SI_0_0 + (Double)Pxy.get(1) * SI_0_1 + (Double)Pxy.get(2) * SI_1_0 + (Double)Pxy.get(3) * SI_1_1;
        return MI;
    }

    private ReactionSimilarityTool() {
    }
}

