/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.layout.SingleMoleculeLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.ZoomToFitLayout;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockReactionCanoniser;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLRXNV2000Reader;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Reader;

public class Reader {
    private static final Logger LOG = Logger.getLogger(Reader.class.getName());

    public IAtomContainer layout(IAtomContainer AtomContainer2) {
        try {
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setMolecule(AtomContainer2, true);
            sdg.generateCoordinates();
            return sdg.getMolecule();
        }
        catch (CDKException e) {
            return AtomContainer2;
        }
    }

    public BufferedImage makeBlankImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        return image;
    }

    public IReaction readReaction(String name) throws IOException {
        return this.readReaction(name, true);
    }

    public IReaction readReaction(String name, boolean reMap) throws IOException {
        return this.readReaction(new File(name).getName().split(".rxn")[0], new File(name).getParent(), reMap, false);
    }

    public IReaction readReaction(String name, String dir, boolean reMap) throws IOException {
        return this.readReaction(name, dir, reMap, false);
    }

    protected List<IReaction> parseRXN(String fileNames) {
        String[] files = fileNames.split(";");
        ArrayList<IReaction> reactions = new ArrayList<IReaction>();
        for (String file : files) {
            String[] f = file.split("\\.(?=[^\\.]+$)");
            if (f[0].equals("rxn")) continue;
            String fileName = f[0].trim() + ".rxn";
            File filepath = new File(fileName);
            if (!filepath.isFile()) {
                Logger.getLogger(Reader.class.getName()).log(Level.WARNING, String.format("RXN file not found! %s", filepath.getName()));
                System.exit(1);
            }
            try {
                Logger.getLogger(Reader.class.getName()).log(Level.INFO, "Annotating Reaction {0}", filepath.getName());
                try (MDLRXNV2000Reader reader = new MDLRXNV2000Reader(new FileReader(filepath));){
                    try {
                        IReaction rxnReactions = reader.read(new Reaction());
                        reader.close();
                        rxnReactions.setID(filepath.getName().split(".rxn")[0]);
                        reactions.add(rxnReactions);
                    }
                    catch (IOException | CDKException ex) {
                        System.err.println("ERROR in Reading Reaction file " + filepath + "\n" + ex);
                    }
                }
            }
            catch (IOException ex) {
                System.err.println("Failed to Read and Annotate RXN File ");
                Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return reactions;
    }

    public IReaction readReaction(String name, String dir, boolean reMap, boolean removeHydrogens) throws IOException {
        IReaction rxnReactions;
        String filepath = dir + File.separator + name + ".rxn";
        List<IReaction> parseRXN = this.parseRXN(filepath);
        IReaction iReaction = rxnReactions = parseRXN.iterator().hasNext() ? parseRXN.iterator().next() : null;
        if (reMap) {
            rxnReactions = this.map(rxnReactions);
            this.renumberMappingIDs(rxnReactions);
        }
        return rxnReactions;
    }

    public IReaction readReaction(String name, String dir) throws IOException {
        return this.readReaction(name, dir, false, false);
    }

    public IAtomContainer readMDLMolecule(String name, String dir) throws FileNotFoundException, CDKException {
        String filepath = dir + name + ".mol";
        MDLV2000Reader reader = new MDLV2000Reader(new FileReader(filepath));
        IAtomContainer AtomContainer2 = reader.read(new AtomContainer());
        AtomContainer2.setID(name);
        return AtomContainer2;
    }

    public IReaction canonise(IReaction reaction) {
        BlockReactionCanoniser labeller = new BlockReactionCanoniser();
        return labeller.getCanonicalReaction(reaction);
    }

    public IReaction map(IReaction reaction) {
        try {
            ReactionMechanismTool rmt = new ReactionMechanismTool(reaction, true, false, false, new StandardizeReaction());
            return rmt.getSelectedSolution().getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens();
        }
        catch (Exception e) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, e);
            return reaction;
        }
    }

    public void writeToFile(Image image, String outputDirPath, String name) throws IOException {
        File outfile;
        File outputDir = new File(outputDirPath);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        if (!(outfile = new File(outputDir, name + ".png")).exists()) {
            outfile.createNewFile();
        }
        ImageIO.write((RenderedImage)((Object)image), "PNG", outfile);
    }

    public void addImplicitHydrogens(IReaction reaction) {
        this.addImplicitHydrogens(reaction.getReactants());
        this.addImplicitHydrogens(reaction.getProducts());
    }

    public void addImplicitHydrogens(IAtomContainerSet molSet) {
        for (IAtomContainer atomContainer : molSet.atomContainers()) {
            this.addImplicitHydrogens(atomContainer);
        }
    }

    public void addImplicitHydrogens(IAtomContainer atomContainer) {
        try {
            CDKHydrogenAdder.getInstance(DefaultChemObjectBuilder.getInstance()).addImplicitHydrogens(atomContainer);
        }
        catch (CDKException e) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void typeAtoms(IAtomContainer atomContainer) {
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
        }
        catch (CDKException e) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    protected void renumberMappingIDs(IReaction reaction) {
        int i = 1;
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            a0.setID(String.valueOf(i));
            a1.setID(String.valueOf(i));
            mapping.setID(String.valueOf(i));
            ++i;
        }
    }

    public void draw(DirectMoleculeDrawer molDrawer, IAtomContainer AtomContainer2, String dirPath, String name) throws IOException {
        int width = 700;
        int height = 700;
        SingleMoleculeLayout layout = new SingleMoleculeLayout(molDrawer.getParams());
        layout.layout(AtomContainer2, new Vector2d(width / 2, height / 2));
        ZoomToFitLayout layout2 = new ZoomToFitLayout(molDrawer);
        BufferedImage image = this.makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        layout2.layout(AtomContainer2, new Dimension(width, height), g);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        ImageIO.write((RenderedImage)image, "PNG", new File(dir, name + ".png"));
    }
}

