/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;

public class MappingTransformation
implements ITransformation<IReaction> {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MappingTransformation.class);
    private static final Logger LOG = Logger.getLogger(MappingTransformation.class.getName());

    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        try {
            boolean forcedMapping = false;
            boolean generate2D = false;
            boolean generate3D = false;
            ReactionMechanismTool rmt = new ReactionMechanismTool(reaction, forcedMapping, generate2D, generate3D, new StandardizeReaction());
            return rmt.getSelectedSolution().getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens();
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }
}

