/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public class ReactionAromatizationTransformation
implements ITransformation<IReaction> {
    private static final Logger LOG = Logger.getLogger(ReactionAromatizationTransformation.class.getName());

    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        for (IAtomContainer atomContainer : ReactionManipulator.getAllAtomContainers(reaction)) {
            try {
                ExtAtomContainerManipulator.aromatizeDayLight(atomContainer);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        }
        return reaction;
    }
}

