/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.labelling;

import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.signature.MoleculeSignature;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class SignatureMoleculeLabeller
implements ICanonicalMoleculeLabeller {
    private static final Logger LOG = Logger.getLogger(SignatureMoleculeLabeller.class.getName());

    @Override
    public IAtomContainer getCanonicalMolecule(IAtomContainer container) {
        try {
            IAtomContainer permute = container.clone();
            if (container.getID() != null) {
                permute.setID(container.getID());
            }
            for (int i = 0; i < permute.getAtomCount(); ++i) {
                if (container.getAtom(i).getID() == null) continue;
                permute.getAtom(i).setID(container.getAtom(i).getID());
            }
            int[] canonicalPermutation = this.getCanonicalPermutation(permute);
            this.permuteWithoutClone(canonicalPermutation, permute);
            return permute;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(SignatureMoleculeLabeller.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public int[] getCanonicalPermutation(IAtomContainer container) {
        MoleculeSignature molSig = new MoleculeSignature(container);
        return molSig.getCanonicalLabels();
    }

    private void permuteWithoutClone(int[] p, IAtomContainer atomContainer) {
        int n = atomContainer.getAtomCount();
        IAtom[] permutedAtoms = new IAtom[n];
        for (int i = 0; i < n; ++i) {
            IAtom atom;
            permutedAtoms[p[i]] = atom = atomContainer.getAtom(i);
            atom.setProperty("label", p[i]);
        }
        atomContainer.setAtoms(permutedAtoms);
        IBond[] bonds = AtomContainerManipulator.getBondArray(atomContainer);
        Arrays.sort(bonds, new Comparator<IBond>(){

            @Override
            public int compare(IBond o1, IBond o2) {
                int u = (Integer)o1.getAtom(0).getProperty("label");
                int v = (Integer)o1.getAtom(1).getProperty("label");
                int x = (Integer)o2.getAtom(0).getProperty("label");
                int y = (Integer)o2.getAtom(1).getProperty("label");
                int min1 = Math.min(u, v);
                int min2 = Math.min(x, y);
                int max1 = Math.max(u, v);
                int max2 = Math.max(x, y);
                int minCmp = Integer.compare(min1, min2);
                if (minCmp != 0) {
                    return minCmp;
                }
                int maxCmp = Integer.compare(max1, max2);
                if (maxCmp != 0) {
                    return maxCmp;
                }
                System.err.println("pokemon!");
                throw new InternalError();
            }
        });
        atomContainer.setBonds(bonds);
    }
}

