/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLRXNFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Reader;

public class MDLRXNV2000Reader
extends DefaultChemObjectReader {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLRXNV2000Reader.class);
    private static final Logger LOG = Logger.getLogger(MDLRXNV2000Reader.class.getName());
    BufferedReader input = null;

    public MDLRXNV2000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV2000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.mode = mode;
    }

    public MDLRXNV2000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV2000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLRXNV2000Reader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return MDLRXNFormat.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class classObject) {
        Class<?>[] interfaces;
        for (Class<?> intf : interfaces = classObject.getInterfaces()) {
            if (IChemModel.class.equals(intf)) {
                return true;
            }
            if (IChemFile.class.equals(intf)) {
                return true;
            }
            if (!IReaction.class.equals(intf)) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IReaction) {
            return (T)this.readReaction(object.getBuilder());
        }
        if (object instanceof IReactionSet) {
            IReactionSet reactionSet = object.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            reactionSet.addReaction(this.readReaction(object.getBuilder()));
            return (T)reactionSet;
        }
        if (object instanceof IChemModel) {
            IChemModel model = object.getBuilder().newInstance(IChemModel.class, new Object[0]);
            IReactionSet reactionSet = object.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            reactionSet.addReaction(this.readReaction(object.getBuilder()));
            model.setReactionSet(reactionSet);
            return (T)model;
        }
        if (object instanceof IChemFile) {
            IChemFile chemFile = object.getBuilder().newInstance(IChemFile.class, new Object[0]);
            IChemSequence sequence = object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            sequence.addChemModel((IChemModel)this.read((IChemObject)object.getBuilder().newInstance(IChemModel.class, new Object[0])));
            chemFile.addChemSequence(sequence);
            return (T)chemFile;
        }
        throw new CDKException("Only supported are Reaction and ChemModel, and not " + object.getClass().getName() + ".");
    }

    public boolean accepts(IChemObject object) {
        if (object instanceof IReaction) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        if (object instanceof IChemFile) {
            return true;
        }
        return object instanceof IReactionSet;
    }

    private IReaction readReaction(IChemObjectBuilder builder) throws CDKException {
        String readMolID;
        MDLV2000Reader reader;
        String molFileLine;
        StringBuilder molFile;
        int i;
        IReaction reaction = builder.newInstance(IReaction.class, new Object[0]);
        try {
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
        }
        catch (IOException exception) {
            logger.debug(exception);
            throw new CDKException("Error while reading header of RXN file", exception);
        }
        int reactantCount = 0;
        int productCount = 0;
        try {
            String countsLine = this.input.readLine();
            StringTokenizer tokenizer = new StringTokenizer(countsLine);
            reactantCount = Integer.valueOf(tokenizer.nextToken());
            logger.info("Expecting " + reactantCount + " reactants in file");
            productCount = Integer.valueOf(tokenizer.nextToken());
            logger.info("Expecting " + productCount + " products in file");
        }
        catch (IOException | NumberFormatException exception) {
            logger.debug(exception);
            throw new CDKException("Error while counts line of RXN file", exception);
        }
        try {
            for (i = 1; i <= reactantCount; ++i) {
                molFile = new StringBuilder();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLV2000Reader(new StringReader(molFile.toString()), this.mode);
                IAtomContainer reactant = (IAtomContainer)reader.read((IChemObject)builder.newInstance(IAtomContainer.class, new Object[0]));
                if (reactant == null) continue;
                readMolID = (String)reactant.getProperty("cdk:Title");
                if (readMolID != null) {
                    reactant.setID(readMolID.trim());
                }
                reaction.addReactant(reactant);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug(exception);
            throw new CDKException("Error while reading reactant", exception);
        }
        try {
            for (i = 1; i <= productCount; ++i) {
                molFile = new StringBuilder();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLV2000Reader(new StringReader(molFile.toString()));
                IAtomContainer product = (IAtomContainer)reader.read((IChemObject)builder.newInstance(IAtomContainer.class, new Object[0]));
                if (product == null) continue;
                readMolID = (String)product.getProperty("cdk:Title");
                if (readMolID != null) {
                    product.setID(readMolID.trim());
                }
                reaction.addProduct(product);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug(exception);
            throw new CDKException("Error while reading products", exception);
        }
        logger.info("Reading atom-atom mapping from file");
        IAtomContainer reactingSide = builder.newInstance(IAtomContainer.class, new Object[0]);
        Iterator<IAtomContainer> molecules = reaction.getReactants().atomContainers().iterator();
        while (molecules.hasNext()) {
            reactingSide.add(molecules.next());
        }
        IAtomContainer producedSide = builder.newInstance(IAtomContainer.class, new Object[0]);
        molecules = reaction.getProducts().atomContainers().iterator();
        while (molecules.hasNext()) {
            producedSide.add(molecules.next());
        }
        int mappingCount = 0;
        block16: for (int i2 = 0; i2 < reactingSide.getAtomCount(); ++i2) {
            for (int j = 0; j < producedSide.getAtomCount(); ++j) {
                IAtom eductAtom = reactingSide.getAtom(i2);
                IAtom productAtom = producedSide.getAtom(j);
                if (eductAtom.getProperty("cdk:AtomAtomMapping") == null || !eductAtom.getProperty("cdk:AtomAtomMapping").equals(productAtom.getProperty("cdk:AtomAtomMapping"))) continue;
                reaction.addMapping(builder.newInstance(IMapping.class, eductAtom, productAtom));
                ++mappingCount;
                continue block16;
            }
        }
        logger.info("Mapped atom pairs: " + mappingCount);
        return reaction;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

