/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.rxnfile.Substructure;
import uk.ac.ebi.reactionblast.tools.rxnfile.SuperAtomContainer;
import uk.ac.ebi.reactionblast.tools.rxnfile.SuperAtoms;

public abstract class MDLReaderBase
extends DefaultChemObjectReader {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLReaderBase.class);
    protected SuperAtomContainer superAtomContainer;

    public static void replaceAtom(IAtomContainer molecule, IAtom prevAtom, IPseudoAtom pseudoAtom) {
        if (prevAtom.getPoint2d() != null) {
            pseudoAtom.setPoint2d(prevAtom.getPoint2d());
        }
        if (prevAtom.getPoint3d() != null) {
            pseudoAtom.setPoint3d(prevAtom.getPoint3d());
        }
        AtomContainerManipulator.replaceAtomByAtom(molecule, prevAtom, pseudoAtom);
    }

    protected void createAtomProperty(IAtomContainer molecule, String line, int linecount) throws CDKException {
        block9: {
            block10: {
                block8: {
                    if (!line.startsWith("M  CHG")) break block8;
                    int infoCount = Integer.parseInt(this.extractString(line, 6, 9));
                    StringTokenizer st = new StringTokenizer(line.substring(9));
                    for (int i = 1; i <= infoCount; ++i) {
                        String token = st.nextToken();
                        int atomNumber = Integer.parseInt(token.trim());
                        token = st.nextToken();
                        int charge = Integer.parseInt(token.trim());
                        molecule.getAtom(atomNumber - 1).setFormalCharge(charge);
                    }
                    break block9;
                }
                if (!line.startsWith("M  ISO")) break block10;
                try {
                    String countString = this.extractString(line, 6, 10);
                    int infoCount = Integer.parseInt(countString);
                    StringTokenizer st = new StringTokenizer(line.substring(10));
                    for (int i = 1; i <= infoCount; ++i) {
                        int atomNumber = Integer.parseInt(st.nextToken().trim());
                        int absMass = Integer.parseInt(st.nextToken().trim());
                        if (absMass == 0) continue;
                        IAtom isotope = molecule.getAtom(atomNumber - 1);
                        isotope.setMassNumber(absMass);
                    }
                }
                catch (NumberFormatException exception) {
                    String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                    logger.error(error);
                    this.handleError("NumberFormatException in isotope information.", linecount, 7, 11, exception);
                }
                break block9;
            }
            if (!line.startsWith("M  RAD")) break block9;
            try {
                String countString = this.extractString(line, 6, 9);
                int infoCount = Integer.parseInt(countString);
                StringTokenizer st = new StringTokenizer(line.substring(9));
                for (int i = 1; i <= infoCount; ++i) {
                    int atomNumber = Integer.parseInt(st.nextToken().trim());
                    int spinMultiplicity = Integer.parseInt(st.nextToken().trim());
                    if (spinMultiplicity <= 1) continue;
                    IAtom radical = molecule.getAtom(atomNumber - 1);
                    for (int j = 2; j <= spinMultiplicity; ++j) {
                        molecule.addSingleElectron(molecule.getBuilder().newInstance(ISingleElectron.class, radical));
                    }
                }
            }
            catch (NumberFormatException exception) {
                String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                logger.error(error);
                this.handleError("NumberFormatException in radical information", linecount, 7, 10, exception);
            }
        }
    }

    protected void createGroupOldVersion(BufferedReader input, IAtomContainer outputContainer, IAtomContainer molecule, String line, int linecount) throws IOException, CDKException {
        try {
            String atomNumberString = this.extractString(line, 3, 6);
            int atomNumber = Integer.parseInt(atomNumberString);
            String atomName = input.readLine();
            IAtom prevAtom = outputContainer.getAtom(atomNumber - 1);
            IPseudoAtom pseudoAtom = molecule.getBuilder().newInstance(IPseudoAtom.class, prevAtom);
            pseudoAtom.setSymbol(prevAtom.getSymbol());
            pseudoAtom.setLabel(atomName);
            if (prevAtom.getPoint2d() != null) {
                pseudoAtom.setPoint2d(prevAtom.getPoint2d());
            }
            if (prevAtom.getPoint3d() != null) {
                pseudoAtom.setPoint3d(prevAtom.getPoint3d());
            }
            AtomContainerManipulator.replaceAtomByAtom(molecule, prevAtom, pseudoAtom);
        }
        catch (NumberFormatException exception) {
            String error = "Error (" + exception.toString() + ") while parsing line " + linecount + ": " + line + " in property block.";
            logger.error(error);
            this.handleError("NumberFormatException in group information", linecount, 4, 7, exception);
        }
    }

    protected void createSgroupProperty(IAtomContainer molecule, IAtomContainer outputContainer, String line, int linecount) throws CDKException {
        try {
            String property;
            switch (property = this.extractString(line, 0, 6)) {
                case "M  STY": {
                    int entryCount = this.extractInt(line, 6, 9);
                    this.superAtomContainer = new SuperAtomContainer(entryCount);
                    for (int i = 0; i < entryCount; ++i) {
                        int offset = i * 8;
                        int sgroupIndex = this.extractInt(line, offset + 10, offset + 13);
                        String sgroupType = this.extractString(line, offset + 14, offset + 17);
                        if (!"SUP".equals(sgroupType)) {
                            throw new RuntimeException("Error parsing Substructure, only Superatom is supported.");
                        }
                        Substructure sub = new Substructure(sgroupIndex - 1, sgroupType);
                        this.superAtomContainer.add(sub);
                    }
                    break;
                }
                case "M  SLB": {
                    int entryCount = this.extractInt(line, 6, 9);
                    for (int i = 0; i < entryCount; ++i) {
                        int offset = i * 8;
                        int sgroupIndex = this.extractInt(line, offset + 10, offset + 13);
                        int sgroupIdentifier = this.extractInt(line, offset + 14, offset + 17);
                        Substructure substructure = this.superAtomContainer.getSubstructures(sgroupIndex - 1);
                        substructure.setSGroupIdentifier(sgroupIdentifier);
                    }
                    break;
                }
                case "M  SAL": {
                    int sgroupIndex = this.extractInt(line, 6, 10);
                    Substructure substructure = this.superAtomContainer.getSubstructures(sgroupIndex - 1);
                    int entryCount = this.extractInt(line, 10, 13);
                    for (int i = 0; i < entryCount; ++i) {
                        int offset = i * 4;
                        int atomIndex = this.extractInt(line, offset + 13, offset + 17);
                        SuperAtoms superAtom = new SuperAtoms();
                        superAtom.setIndex(atomIndex - 1);
                        superAtom.setPrevAtom(outputContainer.getAtom(atomIndex - 1));
                        substructure.add(superAtom);
                    }
                    break;
                }
                case "M  SBL": {
                    int sgroupIndex = this.extractInt(line, 6, 10);
                    Substructure substructure = this.superAtomContainer.getSubstructures(sgroupIndex - 1);
                    int entryCount = this.extractInt(line, 10, 13);
                    for (int i = 0; i < entryCount; ++i) {
                        int offset = i * 4;
                        int bondIndex = this.extractInt(line, offset + 13, offset + 17);
                        substructure.addCrossingBond(bondIndex - 1, outputContainer.getBond(bondIndex - 1));
                    }
                    break;
                }
                case "M  SMT": {
                    int sgroupIndex = this.extractInt(line, 6, 10);
                    Substructure substructure = this.superAtomContainer.getSubstructures(sgroupIndex - 1);
                    String label = this.extractString(line, 10, line.length());
                    for (SuperAtoms sa : substructure.atoms()) {
                        IPseudoAtom pseudoAtom = molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[0]);
                        pseudoAtom.setLabel(label);
                        pseudoAtom.setSymbol(sa.getPrevAtom().getSymbol());
                        sa.setPseudoAtom(pseudoAtom);
                        MDLReaderBase.replaceAtom(outputContainer, sa.getPrevAtom(), sa.getPseudoAtom());
                    }
                    break;
                }
                case "M  SBV": {
                    int sgroupIndex = this.extractInt(line, 6, 10);
                    Substructure substructure = this.superAtomContainer.getSubstructures(sgroupIndex - 1);
                    int bondIndex = this.extractInt(line, 10, 14);
                    double x = this.extractFloat(line, 14, 24);
                    double y = this.extractFloat(line, 24, 34);
                    substructure.setCrossingVector(outputContainer.getBond(bondIndex - 1), x, y);
                    break;
                }
            }
        }
        catch (NumberFormatException exception) {
            String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
            logger.error(error);
            this.handleError("NumberFormatException in radical information", linecount, 7, 10, exception);
        }
    }

    protected void createPseudoAtomProperty(IAtomContainer molecule, IAtomContainer outputContainer, String line, int RGroupCounter, int aliasAtomNumber) {
        String[] aliasArray = line.split("\\\\");
        String alias = "";
        for (String aliasArray1 : aliasArray) {
            alias = alias + aliasArray1;
        }
        IAtom aliasAtom = outputContainer.getAtom(aliasAtomNumber);
        if (aliasAtom instanceof IPseudoAtom) {
            ((IPseudoAtom)aliasAtom).setLabel(alias);
            return;
        }
        IAtom newPseudoAtom = molecule.getBuilder().newInstance(IPseudoAtom.class, alias);
        if (aliasAtom.getPoint2d() != null) {
            newPseudoAtom.setPoint2d(aliasAtom.getPoint2d());
        }
        if (aliasAtom.getPoint3d() != null) {
            newPseudoAtom.setPoint3d(aliasAtom.getPoint3d());
        }
        outputContainer.addAtom(newPseudoAtom);
        List<IBond> bondsOfAliasAtom = outputContainer.getConnectedBondsList(aliasAtom);
        for (int i = 0; i < bondsOfAliasAtom.size(); ++i) {
            IBond bondOfAliasAtom = bondsOfAliasAtom.get(i);
            IAtom connectedToAliasAtom = bondOfAliasAtom.getConnectedAtom(aliasAtom);
            IBond newBond = bondOfAliasAtom.getBuilder().newInstance(IBond.class, new Object[0]);
            newBond.setAtoms(new IAtom[]{connectedToAliasAtom, newPseudoAtom});
            newBond.setOrder(bondOfAliasAtom.getOrder());
            outputContainer.addBond(newBond);
            outputContainer.removeBond(aliasAtom, connectedToAliasAtom);
        }
        outputContainer.removeAtom(aliasAtom);
        ++RGroupCounter;
    }

    protected void createRGroupAtomProperties(String line, Map<Integer, IPseudoAtom> rAtoms, int Rnumber) {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        st.nextToken();
        st.nextToken();
        while (st.hasMoreTokens()) {
            Integer position = new Integer(st.nextToken());
            Rnumber = new Integer(st.nextToken());
            IPseudoAtom pseudoAtom = rAtoms.get(position);
            if (pseudoAtom == null) continue;
            pseudoAtom.setLabel("R" + Rnumber);
        }
    }

    public abstract void customizeJob();

    public float extractFloat(String string, int start, int stop) {
        string = string.substring(start, stop);
        string = string.trim();
        float value = 0.0f;
        if ("".equals(string)) {
            return 0.0f;
        }
        try {
            value = Float.parseFloat(string);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error trying to parse: " + string + " as a float.");
        }
        return value;
    }

    public int extractInt(String string, int start, int stop) {
        string = string.substring(start, stop);
        string = string.trim();
        int value = 0;
        if ("".equals(string)) {
            return 0;
        }
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error trying to parse: " + string + " as an integer.");
        }
        return value;
    }

    public String extractString(String string, int start, int stop) {
        string = string.substring(start, stop);
        string = string.trim();
        return string;
    }
}

