/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.utility;

import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import uk.ac.ebi.reactionblast.fingerprints.Feature;
import uk.ac.ebi.reactionblast.fingerprints.PatternFingerprinter;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IFeature;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;

public class EBIDoubleUtility {
    private static final long serialVersionUID = 7683452581122892189L;
    private static final Logger LOG = Logger.getLogger(EBIDoubleUtility.class.getName());

    public static double[] append(double[] val1, double[] val2) throws CDKException {
        double[] feature = null;
        if (val1.length > 0 && val2.length > 0) {
            feature = new double[val1.length + val2.length];
            int index = 0;
            for (int i = 0; i < val1.length; ++i) {
                feature[index++] = val1[i];
            }
            for (int j = 0; j < val2.length; ++j) {
                feature[index++] = val2[j];
            }
        } else {
            throw new CDKException("Index < 0: ");
        }
        return feature;
    }

    public static IPatternFingerprinter Union(IPatternFingerprinter val1, IPatternFingerprinter val2) throws CDKException {
        PatternFingerprinter patternFingerprinter = new PatternFingerprinter(val1.getFingerprintSize() + val2.getFingerprintSize());
        if (val1.getFingerprintSize() > 0 && val2.getFingerprintSize() > 0) {
            IFeature feature;
            for (int i = 0; i < val1.getFeatureCount(); ++i) {
                feature = val1.getFeature(i);
                patternFingerprinter.add(new Feature(feature.getPattern(), feature.getWeight()));
            }
            for (int j = 0; j < val2.getFeatureCount(); ++j) {
                feature = val2.getFeature(j);
                patternFingerprinter.add(new Feature(feature.getPattern(), feature.getWeight()));
            }
        } else {
            throw new CDKException("Index < 0: ");
        }
        return patternFingerprinter;
    }

    public static double[] append(double[] val1, double[] val2, double[] val3) throws CDKException {
        double[] feature = null;
        if (val1.length > 0 && val2.length > 0 && val3.length > 0) {
            feature = new double[val1.length + val2.length + val3.length];
            int index = 0;
            for (int i = 0; i < val1.length; ++i) {
                feature[index++] = val1[i];
            }
            for (int j = 0; j < val2.length; ++j) {
                feature[index++] = val2[j];
            }
            for (int k = 0; k < val3.length; ++k) {
                feature[index++] = val3[k];
            }
        } else {
            throw new CDKException("Index < 0: ");
        }
        return feature;
    }

    public static IPatternFingerprinter Union(IPatternFingerprinter val1, IPatternFingerprinter val2, IPatternFingerprinter val3) throws CDKException {
        PatternFingerprinter patternFingerprinter = new PatternFingerprinter(val1.getFingerprintSize() + val2.getFingerprintSize() + val3.getFingerprintSize());
        if (val1.getFingerprintSize() > 0 && val2.getFingerprintSize() > 0) {
            IFeature feature;
            for (int i = 0; i < val1.getFeatureCount(); ++i) {
                feature = val1.getFeature(i);
                patternFingerprinter.add(new Feature(feature.getPattern(), feature.getWeight()));
            }
            for (int j = 0; j < val2.getFeatureCount(); ++j) {
                feature = val2.getFeature(j);
                patternFingerprinter.add(new Feature(feature.getPattern(), feature.getWeight()));
            }
            for (int k = 0; k < val3.getFeatureCount(); ++k) {
                feature = val3.getFeature(k);
                patternFingerprinter.add(new Feature(feature.getPattern(), feature.getWeight()));
            }
        } else {
            throw new CDKException("Index < 0: ");
        }
        return patternFingerprinter;
    }

    public static boolean isSubset(double[] val1, double[] val2) throws CDKException {
        boolean flag = true;
        if (val1.length > 0 && val2.length > 0) {
            for (int i = 0; i < val1.length; ++i) {
                if (!(val1[i] > val2[i])) continue;
                flag = false;
                break;
            }
        } else {
            throw new CDKException("Index <0: ");
        }
        return flag;
    }

    public static boolean isSuperset(double[] val1, double[] val2) throws CDKException {
        boolean flag = true;
        if (val1.length > 0 && val2.length > 0) {
            for (int i = 0; i < val1.length; ++i) {
                if (!(val1[i] < val2[i])) continue;
                flag = false;
                break;
            }
        } else {
            throw new CDKException("Index <0: ");
        }
        return flag;
    }

    private EBIDoubleUtility() {
    }
}

